// By EVOLVED
// www.evolved-software.com

#define Specularity 1
#define ParallaxMapping 1
#define ParallaxReflection 1

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 View:View;
   float4x4 Project:Projection;
   float4x4 ViewProj:ViewProjection; 
   float4x4 ViewInv:ViewInverse;

//--------------
// tweaks
//--------------
   float4 ViewSize1;
   float4 ViewSize2;
   float4 ShadowBlur1;
   float4 ShadowBlur2;
   float4 ShadowBlur3;
   float4 ReflectVec1;
   float4 ReflectVec2;
   float4 ReflectVec3;
   float2 CamRange;
   float4 FogColor;
   float4 AmbientColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float TileRange;
   float4x4 ShadowProj;
   float4 ShadowPosition;
   float3 ShadowDirection;
   float ShadowBias;
   float Normalz=0.75;
   float Heightvec=0.012;


//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;	
   sampler BaseSampler=sampler_state 
      {
 	Texture=<BaseTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=8;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	Texture=<NormalMapTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=4;
      };
   texture SecondarysTexture <string Name = "";>;	
   sampler SecondarysSampler=sampler_state 
      {
 	Texture=<SecondarysTexture>;
      };
   texture ReflectionTexture <string Name="";>;
   sampler ReflectionSampler=sampler_state
      {
	Texture=<ReflectionTexture>;
	MipFilter=None;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture DepthTexture <string Name = "";>;	
   sampler DepthSampler=sampler_state 
      {
 	Texture=<DepthTexture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture MaskATexture <string Name = "";>;	
   sampler MaskASampler=sampler_state 
      {
 	Texture=<MaskATexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture MaskBTexture <string Name = "";>;	
   sampler MaskBSampler=sampler_state 
      {
 	Texture=<MaskBTexture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture LightDataTexture <string Name = "";>;	
   sampler LightDataSampler=sampler_state 
      {
 	Texture=<LightDataTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };

//--------------
// structs 
//--------------
   struct Input
     {
 	float4 Pos:POSITION;
    	float2 UV:TEXCOORD; 
 	float3 Normal:NORMAL;
 	float3 Tangent:TANGENT;
     };
   struct Out_Lighting
     {
 	float4 Pos:POSITION;
	float2 Tex:TEXCOORD0;
	float4 Proj:TEXCOORD1;
  	float3 TBNRow1:TEXCOORD2; 
  	float3 TBNRow2:TEXCOORD3; 
  	float3 TBNRow3:TEXCOORD4;
 	float4 WorldPos:TEXCOORD5;
 	float3 ViewVec:TEXCOORD6;
 	float3 ViewNor:TEXCOORD7;
     };
   struct Out_Depth
     {
 	float4 Pos:POSITION;
	float2 Tex:TEXCOORD0; 
 	float3 Depth:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN) 
     {
 	Out_Lighting OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
 	OUT.Tex=IN.UV;
	Project[2].z=-1.0/(CamRange.y-CamRange.x), Project[3].z=(CamRange.y-CamRange.x)/CamRange.y;
	float4 PosLinear=mul(mul(float4(WorldPos,1.0),View),Project); 
        OUT.Proj=float4(PosLinear.x*0.5+0.5*PosLinear.w,0.5*PosLinear.w-PosLinear.y*0.5,PosLinear.z,PosLinear.w);
	float3 Normals=normalize(mul(IN.Normal,World)); 
	float3 Tangent=normalize(mul(IN.Tangent,World));
	OUT.TBNRow1=Tangent;
	OUT.TBNRow2=cross(Normals,Tangent);
	OUT.TBNRow3=Normals;
	OUT.WorldPos=float4(WorldPos,0.0); 
	OUT.ViewVec=ViewInv[3].xyz-WorldPos;
	float3x3 WorldTBN=float3x3(OUT.TBNRow1,OUT.TBNRow2,OUT.TBNRow3);
	OUT.ViewNor=mul(OUT.ViewVec,transpose(WorldTBN)); 
	return OUT;
     }
   Out_Depth VS_Depth(Input IN) 
     {
 	Out_Depth OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
 	OUT.Tex=IN.UV;
	Project[2].z=-1.0/(CamRange.y-CamRange.x), Project[3].z=(CamRange.y-CamRange.x)/CamRange.y;
	float4 PosLinear=mul(mul(float4(WorldPos,1),View),Project); 
        OUT.Depth=float3(PosLinear.z,PosLinear.w,0.0);
	return OUT;
     }
   Out_Depth VS_DepthMap(Input IN)     
     {
        Out_Depth OUT;
	float3 WorldPos=mul(IN.Pos,World).xyz;
	OUT.Pos=mul(float4(WorldPos,1.0),ShadowProj);
	OUT.Tex=IN.UV;
      	OUT.Depth=WorldPos-ShadowPosition;
      	return OUT;
     }

//--------------
// pixel shader
//--------------
    float4 PS_Lighting(Out_Lighting IN)  : COLOR
     {
	float2 dx=ddx(IN.Tex), dy=ddy(IN.Tex);	
	float4 Proj=((IN.Proj/IN.Proj.w)*ViewSize2)+ViewSize1;
	float Depth=tex2Dlod(DepthSampler,Proj).x;
	if(abs(Proj.z-Depth)>Proj.z*0.002) discard;
	#if ParallaxMapping == 1
	 float3 ViewNor=normalize(IN.ViewNor);
	 IN.Tex +=(Heightvec*(tex2Dgrad(SecondarysSampler,IN.Tex,dx,dy).w-0.5))*ViewNor.xy;
	 IN.Tex +=(Heightvec*(tex2Dgrad(SecondarysSampler,IN.Tex,dx,dy).w-0.5))*ViewNor.xy;
	 IN.Tex +=(Heightvec*(tex2Dgrad(SecondarysSampler,IN.Tex,dx,dy).w-0.5))*ViewNor.xy;
	#endif
	float4 Diffuse=pow(tex2Dgrad(BaseSampler,IN.Tex,dx,dy),float4(2.2,2.2,2.2,1.0));
	float4 NormalMap=tex2Dgrad(NormalMapSampler,IN.Tex,dx,dy);
	float4 Secondarys=tex2Dgrad(SecondarysSampler,IN.Tex,dx,dy);
	float4 LightMaskA=pow(tex2Dlod(MaskASampler,Proj),float4(1.0,1.0,2.2,2.2));
	float4 LightMaskB=pow(tex2Dlod(MaskBSampler,Proj),2.2);
  	float LightMasks[7]={1,LightMaskA.z,LightMaskA.w,LightMaskB.x,LightMaskB.y,LightMaskB.z,LightMaskB.w};
	float ViewDist=length(IN.ViewVec);
	float3 ViewVec=normalize(IN.ViewVec);
	float3x3 WorldTBN=float3x3(IN.TBNRow1,IN.TBNRow2,IN.TBNRow3);
	float3 Normals=normalize(mul(float3(NormalMap.yw*2-1,Normalz),WorldTBN));
	float ViewNormal=max(dot(ViewVec,Normals),0.0);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1-Specular)*(1-NormalMap.z)*pow(1-ViewNormal,5);
	float Shadows=pow(max(LightMaskA.y-0.5,0.0)*2.0,2.2);
	float3 Lighting=LightDirectionColor*max(dot(LightDirection,Normals),0.0)*Shadows;
	#if Specularity == 1
	 float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.2);
	 float Denominator=Distribution.x-1;
	 float HalfVec=max(dot(normalize(LightDirection+ViewVec),Normals),0.0)*Denominator+1.0001;
	 float3 LightSpecular=(Distribution/(3.141592*HalfVec*HalfVec))*Lighting;
	#else
	 float3 LightSpecular=0;
	#endif
	float4 TileProj=IN.Proj/IN.Proj.w;
        float4 TileCount=tex2Dlod(LightDataSampler,TileProj*0.03125);
	float TileArray=(floor(TileProj.x*8.0)+floor(TileProj.y*8.0)*8.0)*0.00390625;
	int TileDepth=clamp(floor(ViewDist/TileRange),0.0,3.0);
	int Tiles=TileCount[TileDepth];
        for(int i=0; i<Tiles; i++ ) {
	  float4 LightArray=tex2Dlod(LightDataSampler,float4((i+128.0)*0.00390625,TileArray,0.0,0.0));
	  LightArray.xy=float2(LightArray[TileDepth]*0.00390625,0.98828125);
	  float4 LightColor=tex2Dlod(LightDataSampler,LightArray);
	  float LightMask=LightMasks[int(LightColor.w)];
	  if(LightMask>0.0001) {
      	   float4 LightVec=tex2Dlod(LightDataSampler,LightArray+float4(0.0,0.00390625,0.0,0.0))-IN.WorldPos;
	   float4 LightSpot=tex2Dlod(LightDataSampler,LightArray+float4(0.0,0.0078125,0.0,0.0));
	   float Attenuation=length(LightVec.xyz);
	   LightVec.xyz /=Attenuation;
  	   LightColor.xyz *=saturate((dot(LightVec.xyz,LightSpot.xyz)-LightSpot.w)/frac(LightColor.w));
	   LightColor.xyz *=LightMask*max(dot(LightVec.xyz,Normals),0.0)*max(1/(Attenuation/LightVec.w)-1.0,0.0);
	   Lighting +=LightColor.xyz;
	   #if Specularity == 1
	    float HalfVec=max(dot(normalize(LightVec.xyz+ViewVec),Normals),0.0)*Denominator+1.0001;
	    LightSpecular +=(Distribution/(3.141592*HalfVec*HalfVec))*LightColor.xyz;
	   #endif
	  }
	}
	float ReflectionIdx=floor(0.01+LightMaskA.x*255);
	float4 BoxMin=tex2Dlod(LightDataSampler,float4(0.0390625+ReflectionIdx*0.00390625,0,0,0));
	#if ParallaxReflection == 1
	 float3 BoxMax=tex2Dlod(LightDataSampler,float4(0.0390625+ReflectionIdx*0.00390625,0.00390625,0,0));
	 float3 ViewReflection=reflect(-ViewVec,Normals);
	 float3 ReflectionBox=max((BoxMin.xyz-IN.WorldPos.xyz)/ViewReflection,(BoxMax-IN.WorldPos.xyz)/ViewReflection);
	 ViewReflection=IN.WorldPos.xyz+ViewReflection*min(min(ReflectionBox.x,ReflectionBox.y),ReflectionBox.z);
	 ViewReflection=-normalize(ViewReflection-(BoxMin.xyz+((BoxMax-BoxMin.xyz)*0.5)));
	#else
	 float3 ViewReflection=reflect(ViewVec,Normals);
	#endif
	float4 Equirectangular=0.3183*float4(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y),0,0);
	Equirectangular.xy=float2(Equirectangular.x*0.5+0.5,1-Equirectangular.y);
	NormalMap.z=max(NormalMap.z*2,BoxMin.w);
	float2 Roughness=saturate(pow(float2(NormalMap.z,NormalMap.z-2),2));
	float4 Reflection=tex2Dlod(ReflectionSampler,float4(ReflectVec1.z,ReflectVec1.w+ReflectionIdx*0.25,0,0)+Equirectangular*ReflectVec1)*(1-Roughness.x)
	                 +tex2Dlod(ReflectionSampler,float4(ReflectVec2.z,ReflectVec2.w+ReflectionIdx*0.0625,0,0)+Equirectangular*ReflectVec2)*(Roughness.x*Roughness.y)
	                 +tex2Dlod(ReflectionSampler,float4(ReflectVec3.z,ReflectVec3.w+ReflectionIdx*0.015625,0,0)+Equirectangular*ReflectVec3)*(1-Roughness.y);
	LightSpecular +=Reflection.xyz*pow(1.04,Reflection.w*255.0-128.0)*AmbientColor.w;
	Lighting +=AmbientColor.xyz*pow(saturate(LightMaskA.y*2),2.2)*Secondarys.y;
	Lighting *=(1-Specular)*(1-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*32);
	float FogDist=saturate(1-exp(-(ViewDist/FogColor.w)));
	return float4(lerp(Lighting,FogColor.xyz,FogDist),1);
     }
    float4 PS_Depth(Out_Depth IN)  : COLOR
     {
	return float4(IN.Depth.x/IN.Depth.y,0,0,tex2D(BaseSampler,IN.Tex).w);
     }
   float4 PS_DepthMap(Out_Depth IN) : COLOR
     {
	return (0.0125+length(IN.Depth/ShadowPosition.w))*ceil(tex2D(BaseSampler,IN.Tex).w-0.25);
     }
   float4 PS_DepthDir(Out_Depth IN) : COLOR
     {
	return float4(ShadowBias.xx+dot(IN.Depth,ShadowDirection).xx/ShadowPosition.ww,0.0,tex2D(BaseSampler,IN.Tex).w);
     }

//--------------
// techniques   
//--------------
    technique Lighting
      {
 	pass p1
      {
 	vertexShader = compile vs_3_0 VS_Lighting();
 	pixelShader  = compile ps_3_0 PS_Lighting();
	ColorWriteEnable=7;
	AlphaBlendEnable=false;
      }
      }
    technique Depth
      {
 	pass p1
      {
 	vertexShader = compile vs_3_0 VS_Depth();
 	pixelShader  = compile ps_3_0 PS_Depth();
	ColorWriteEnable=1;
	AlphaBlendEnable=false;
	AlphaRef=64;
      }
      }
    technique Depth1
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS_DepthMap();
 	PixelShader  = compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
	AlphaRef=1;
      }
      }
    technique Depth2
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS_DepthMap();
 	PixelShader  = compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=2;
	AlphaBlendEnable=false;
	AlphaRef=1;
      }
      }
    technique Depth3
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS_DepthMap();
 	PixelShader  = compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=4;
	AlphaBlendEnable=false;
	AlphaRef=1;
      }
      }
    technique Depth4
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS_DepthMap();
 	PixelShader  = compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=8;
	AlphaBlendEnable=false;
	AlphaRef=1;
      }
      }
   technique DepthDir1
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS_DepthMap(); 
 	PixelShader  = compile ps_3_0 PS_DepthDir(); 
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
	AlphaRef=1;
      }
      }
   technique DepthDir2
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS_DepthMap(); 
 	PixelShader  = compile ps_3_0 PS_DepthDir(); 
        ColorWriteEnable=2;
	AlphaBlendEnable=false;
	AlphaRef=1;
      }
      }
